/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DatalinkServiceUtil;
import cds.savot.model.ParamSet;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import java.util.Map;

public class SimpleData {
    private String displayString;
    private String type;
    private Map<String, String> params;
    private SavotResource metaResource;

    public SimpleData() {
    }

    public SimpleData(String[] parameters) {
    }

    public String getDisplayString() {
        if (this.displayString == null || this.displayString.isEmpty()) {
            this.setDisplayString();
        }
        return this.displayString;
    }

    public void setDisplayString() {
        StringBuilder defaultLinkLabel = new StringBuilder();
        if (this.params.get("description") != null && !this.params.get("description").isEmpty()) {
            defaultLinkLabel.append(this.params.get("description"));
        } else {
            this.setType();
            if (this.type == null) {
                defaultLinkLabel.append(this.getParams().get("semantics"));
            } else if (this.type.equals("DATALINK_PROC")) {
                ParamSet inputParams = this.metaResource.getParams();
                SavotParam idParam = DatalinkServiceUtil.getInputParams(inputParams, "standardID");
                String standardId = null;
                if (idParam != null) {
                    standardId = SimpleData.processStandardIdDisplayString(idParam.getValue());
                }
                if (standardId != null && !standardId.isEmpty()) {
                    defaultLinkLabel.append(standardId);
                } else {
                    defaultLinkLabel.append(Aladin.chaine.getString(this.type));
                }
            } else {
                defaultLinkLabel.append(Aladin.chaine.getString(this.type));
            }
        }
        if (this.params.containsKey("content_length_display")) {
            defaultLinkLabel.append(" (").append(this.params.get("content_length_display")).append(")");
        }
        this.displayString = defaultLinkLabel.toString();
    }

    private static String processStandardIdDisplayString(String value) {
        String displayStandardIdLabel = null;
        if (value != null && value.contains("ivo://ivoa.net/std/")) {
            displayStandardIdLabel = value.replace("ivo://ivoa.net/std/", "");
        }
        return displayStandardIdLabel;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    public String getType() {
        return this.type;
    }

    public void setType() {
        String semantic = this.params.get("semantics");
        String contentType = this.params.get("content_type");
        if (semantic.equalsIgnoreCase("#this")) {
            this.type = "DATALINK_THISDATASET";
        } else if (semantic.equalsIgnoreCase("#progenitor")) {
            this.type = "DATALINK_PROGENITOR";
        } else if (semantic.equalsIgnoreCase("#derivation")) {
            this.type = "DATALINK_DERIVATION";
        } else if (semantic.equalsIgnoreCase("#auxiliary")) {
            this.type = "DATALINK_AUXILIARY";
        } else if (semantic.equalsIgnoreCase("#weight")) {
            this.type = "DATALINK_WEIGHT";
        } else if (semantic.equalsIgnoreCase("#error")) {
            this.type = "DATALINK_ERROR";
        } else if (semantic.equalsIgnoreCase("#noise")) {
            this.type = "DATALINK_NOISE";
        } else if (semantic.equalsIgnoreCase("#calibration")) {
            this.type = "DATALINK_CALIBRATION";
        } else if (semantic.equalsIgnoreCase("#bias")) {
            this.type = "DATALINK_BIAS";
        } else if (semantic.equalsIgnoreCase("#dark")) {
            this.type = "DATALINK_DARK";
        } else if (semantic.equalsIgnoreCase("#flat")) {
            this.type = "DATALINK_FLAT";
        } else if (semantic.equalsIgnoreCase("#preview")) {
            this.type = "DATALINK_PREVIEW";
        } else if (semantic.equalsIgnoreCase("#preview-image")) {
            this.type = "DATALINK_PREVIEW_IMAGE";
        } else if (semantic.equalsIgnoreCase("#preview-plot")) {
            this.type = "DATALINK_PREVIEW_PLOT";
        } else if (semantic.equalsIgnoreCase("#proc")) {
            this.type = "DATALINK_PROC";
        } else if (semantic.equalsIgnoreCase("#cutout")) {
            this.type = "DATALINK_CUTOUT";
        } else if (contentType != null && contentType.contains("content=hips")) {
            this.type = "DATALINK_HIPS";
        }
    }

    public boolean isSameAs(SimpleData dataToCompare) {
        boolean result = false;
        if (this.toString().equalsIgnoreCase(dataToCompare.toString())) {
            result = true;
        }
        return result;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SavotResource getMetaResource() {
        return this.metaResource;
    }

    public void setMetaResource(SavotResource metaResource) {
        this.metaResource = metaResource;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String toString() {
        StringBuilder stringToPrint = new StringBuilder();
        stringToPrint.append("Display string:").append(this.getDisplayString()).append(", ").append("type:").append(this.getType()).append(", ").append("Params:").append(this.params);
        return stringToPrint.toString();
    }
}

